<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers\Functions;


use IZON\MVC\Config;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use Psr\Container\ContainerInterface;

class RouteLoad extends AbstractFunction {

    public function getCallback(ContainerInterface $container): callable {
        return function(
            $context,
            $controllerId,
            array $parameters = [],
            $methodName = null,
            $locale = null,
            $domainUID = null,
            $forceDomain = false
        ) use ($container) {
            /** @var \IZON\MVC\Routers\Router $router */
            $router = $container->get(Config::ROUTER_IDENTIFIER);
            if($context instanceof \IZON\MVC\Context\ContextInterface) {
                if(is_null($locale)) {
                    $locale = $context->getLocale();
                }
            }
            if(is_string($locale)) {
                $locale = \IZON\Utils\Locale::forLocaleTag($locale);
            }
            return $router->findURL($controllerId, $parameters, $methodName, $locale, $domainUID, $forceDomain);
        };
    }
}
