<?php

declare(strict_types=1);

namespace IZON\Templating\Latte\Helpers;

use IZON\Templating\Latte\Helpers\Abstracts\AbstractFilter;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractFunction;
use IZON\Templating\Latte\Helpers\Abstracts\AbstractMacro;
use IZON\Templating\Latte\TracyBar\LatteHelperTracyBar;
use Latte\Engine;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Nette\Utils\Finder;
use Psr\Container\ContainerInterface;
use Symfony\Component\Finder\SplFileInfo;

class Autoload {

    /** @var Engine */
    protected static $engine;

    /** @var ContainerInterface */
    protected static $container;

    /** @var LatteHelperTracyBar|null */
    protected static $tracyBar;

    public static function init(Engine $engine, ContainerInterface $container, ?LatteHelperTracyBar $tracyBar): Engine {
        self::$engine = $engine;
        self::$container = $container;
        self::$tracyBar = $tracyBar;

        // function
        self::initFilters();
        self::initFunctions();
        self::initMacros();

        return self::$engine;
    }

    protected static function initFilters(): void {

        /** @var SplFileInfo $fileInfo */
        foreach(Finder::findFiles('*Load.php')->from(__DIR__.'/Filters') as $fileInfo) {

            $functionName = sprintf('\IZON\Templating\Latte\Helpers\Filters\%s', $fileInfo->getBasename('.php'));
            $filter = new $functionName();

            if($filter instanceof AbstractFilter) {
                self::$engine->addFilter($filter->getName(), $filter->getCallback(self::$container));
                self::$tracyBar->addFilter($filter->getTracyTitle(), $filter->getTracyDescription());
            }

        }
    }

    protected static function initFunctions(): void {

        /** @var SplFileInfo $fileInfo */
        foreach(Finder::findFiles('*Load.php')->from(__DIR__.'/Functions') as $fileInfo) {

            $functionName = sprintf('\IZON\Templating\Latte\Helpers\Functions\%s', $fileInfo->getBasename('.php'));
            $function = new $functionName();

            if($function instanceof AbstractFunction) {
                self::$engine->addFunction($function->getName(), $function->getCallback(self::$container));
                self::$tracyBar->addFunction($function->getTracyTitle(), $function->getTracyDescription());
            }

        }
    }

    protected static function initMacros(): void {

        $macro = new MacroSet(self::$engine->getCompiler());

        /** @var SplFileInfo $fileInfo */
        foreach(Finder::findFiles('*Load.php')->from(__DIR__.'/Macros') as $fileInfo) {

            $functionName = sprintf('\IZON\Templating\Latte\Helpers\Macros\%s', $fileInfo->getBasename('.php'));
            $function = new $functionName();

            if($function instanceof AbstractMacro) {
                $macro->addMacro(
                    $function->getName(),
                    function(MacroNode $node, PhpWriter $writer) use ($function) {
                        $output = sprintf($function->getMacro(), $node->args);
                        return $writer->write('echo %raw', $output);
                    },
                    null,
                    function(MacroNode $node, PhpWriter $writer) use ($function) {
                        $output = sprintf($function->getTag(), $node->args);
                        return $writer->write('echo %raw', $output);
                    }
                );

                self::$tracyBar->addMacro($function->getTracyTitle(), $function->getTracyDescription());
            }

        }

    }
}
