<?php

namespace IZON\Tasks;

use Exception;
use IZON\MVC\Config;

/**
 * trida spoustejici tasky
 */
class TaskRunner {

    protected $baseDir;

    protected $configClass;
    /**
     * @var Config
     */
    protected $config;

    /**
     * @param Config|string $baseDir jaky je basedir aplikace
     * @param null|string $configClass jaka trida configu se ma pouzit
     */
    function __construct($baseDir, $configClass = null) {
        if($baseDir instanceof Config) {
            $this->config = $baseDir;
            $this->baseDir = $this->config->getBaseDir();
        } else {
            if($configClass === null) {
                throw new Exception('$configClass not provided.');
            }
            // vytvorit a inicializovat aplikaci
            $this->config = new $configClass($baseDir);
        }

        // sets basedir of aplication for easier url handling
        // TODO: potom nabradir necim co se jednoduseji sptavuje
        define("__BASE_DIR__", $this->config->getBaseDir());

    }

    function init() {

        try {
            $this->config->init();
        } catch(Exception $exception) {
            $log = $config->getAppLogger();
            $log->error("Při inicializaci tasku doslo k chybe", ["exception" => $exception]);
            throw $exception;
        }
    }

    function run($argc, $argv) {
        if($argc == 1) {
            echo("Tasku se musi jako prvni parametr predat identfikator tasku" . PHP_EOL);
            $this->listOfTasks();
            exit(1);
        }

        $config = $this->config;
        // di container
        $container = $config->getContainer();

        $taskIdentifier = $argv[1];
        if( !$container->has($taskIdentifier) ) {
            echo("Task ". $taskIdentifier ." neni definovan");
            exit(1);
        }

        /* @var $task Task */
        $task = $container->get($taskIdentifier);
        if( !($task instanceof Task) ) {
            echo("Task ". get_class($task) ." neimplementuje rozhrani ". Task::class ." neni ho mozne vyvolat.");
            exit(1);
        }

        try {
            $task->run($argv);
        }  catch(Exception $exception) {
            $log = $config->getAppLogger();
            $log->error("Při behu tasku doslo k chybe", ["exception" => $exception]);
            throw $exception;
        }
    }

    /**
     * Print list of tasks
     */
    public function listOfTasks(){
        //TODO: make it clever
        //TODO: dont check by 'task' string but by interface Task
        echo 'List of available tasks: ' . PHP_EOL;
        $container = $this->config->getDefinedKeys();
        foreach($container as $item){
            if(strpos($item, 'task') !== FALSE){
                echo $item . PHP_EOL;
            }
        }
    }
}
