<?php
namespace IZON\Tasks\BaseTasks;

use IZON\Tasks\Domain\RegisteredTask;
use IZON\Tasks\Services\ITaskWatchdogService;
use IZON\Tasks\Task;

/**
 * db logged task
 * NOTE: All DB logging stuff should be moved to its own library to not add more dependences
 * @author Lukáš Linhart <linhart@izon.cz>
 */
abstract class DatabaseLoggedTask implements Task {
  
  /**
   *
   * @var ITaskWatchdogService
   */
  protected $taskWatchDogService;
  /**
   *
   * @var RegisteredTask
   */
  protected $registeredTask;
          
  function __construct(ITaskWatchdogService $taskWatchDogService) {
    $this->taskWatchDogService = $taskWatchDogService;
    $this->registeredTask = $this->taskWatchDogService->getRegisteredTask(get_class($this));
  }
  
  abstract public function runTask(array $args);
  
  public function run(array $args) {
    $taskRun = $this->taskWatchDogService->beginTaskRun($this->registeredTask);
    $this->runTask($args);
    $this->taskWatchDogService->endTaskRun($taskRun);
  }

}
