<?php

namespace IZON\Tasks\BaseTasks;

use GoPay\Http\Log\Logger;
use IZON\MVC\Config;
use IZON\Tasks\Exceptions\TaskInitException;
use IZON\Tasks\Task;

/**
 * Created by PhpStorm.
 * User: honza
 * Date: 25.8.17
 * Time: 8:10
 */
abstract class LoggerTask implements Task {

    /**
     * @var \IZON\Logs\Logger
     */
    protected $logger = null;
    /**
     * Determine if you want to send emails in log fatal or error
     * @var bool
     */
    protected $sendEmails = true;

    /**
     * Set location of log files
     *
     * Check if directory exist and if is writeable
     *
     * @param string $dirPath absolute path of directory
     * @throws TaskInitException
     */
    public function setLogLocation($dirPath) {
        // left to prevent app initialization errors
    }

    /**
     * Set log file name
     *
     * @param $fileName
     * @throws TaskInitException
     */
    public function setLogName($fileName) {
        // left to prevent app initialization errors
    }

    /**
     * Set max log file size
     * @param int $fileSize Max. file size of log in MB
     * @throws TaskInitException
     */
    public function setMaxLogFileSize($fileSize) {
        // left to prevent app initialization errors
    }

    /**
     * @param int $count count of max backup files of logger
     * @throws TaskInitException
     */
    public function setMaxBackupLogFiles($count) {
        // left to prevent app initialization errors
    }

    /**
     * True -> send error mails
     * False -> do not send emails
     * @param bool $bool
     */
    public function setSendEmails($bool){
        $this->sendEmails = $bool;
    }

    /**
     * Init logger
     * @throws TaskInitException
     */
    protected function initLogger() {
        $this->logger = \IZON\Logs\Logger::getLogger('tasks');
    }

    /**
     * Write string into log like info
     * @var string $toWrite string to write
     */
    public function textToLog($toWrite) {
        $this->logger->info($toWrite);
    }

    /**
     * Write error into log
     * If send emails is enable - send email
     * @param $message
     * @param \Exception|null $exception
     */
    public function error($message, $exception = null) {
        $context = [];
        if ($exception != null) {
            $context['exception'] = $exception;
        }
        $this->logger->error($message, $context);
    }

    /**
     * Write fatal into log
     * If send emails is enable - send email
     * @param $message
     * @param null $exception
     */
    public function fatal($message, $exception = null) {
        $context = [];
        if ($exception != null) {
            $context['exception'] = $exception;
        }
        $this->logger->critical($message, $context);
    }

    /**
     * Init and run Task
     * On succes - write into log file 'success' string
     * Do not catch any exception
     * @param array $args
     */
    public function run(array $args) {
        $this->initLogger();
        $this->runTask();
        $this->textToLog('success');
    }

    abstract public function runTask();


}
