<?php

namespace IZON\Tasks\Domain;

use IZON\DB\DBObject;
use function IZON\DB\transientField;

/**
 * Description of RegisteredTask
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class RegisteredTask implements DBObject {

  /**
   *
   * @var integer
   */
  protected $id;

  /**
   *
   * @var string
   */
  protected $class;

  /**
   *
   * @var integer
   */
  protected $maxTime;

  /**
   *
   * @var integer
   */
  protected $active;

  /**
   *
   * @var RegisteredTaskTranslation[]
   */
  protected $translations;

  public static function __translations() {
    return transientField();
  }

  public function __construct() {
    
  }

  /**
   * 
   */
  public static function __tableName() {
    return 'core_registered_tasks';
  }

  /**
   * GETTERS
   */

  /**
   *
   * @return integer
   */
  public function getId() {
    return $this->id;
  }

  /**
   *
   * @return string
   */
  public function getClass() {
    return $this->class;
  }

  /**
   *
   * @return integer
   */
  public function getMaxTime() {
    return $this->maxTime;
  }

  /**
   *
   * @return integer
   */
  public function getActive() {
    return $this->active;
  }

  /**
   * SETTERS
   */
  public function setId($input) {
    $this->id = $input;
  }

  public function setClass($input) {
    $this->class = $input;
  }

  public function setMaxTime($input) {
    $this->maxTime = $input;
  }

  public function setActive($input) {
    $this->active = $input;
  }
  
  public function getTranslations() {
    return $this->translations;
  }

  public function setTranslations(array $translations) {
    $this->translations = $translations;
  }



}
