<?php

namespace IZON\Tasks\Tests;

use Exception;

use IZON\Logs\Logger;
use IZON\Tasks\BaseTasks\LoggerTask;
use IZON\Tasks\Exceptions\TaskInitException;
use PHPUnit\Framework\TestCase;


/**
 * test formulare
 * 
 * @covers FormSet
 */
class TestLoggerTask extends TestCase {

    protected function setUp(){
        if(!file_exists("./tmp")) {
            mkdir("./tmp");
        }
    }

    /**
     * Test of setters
     */
    public function testSetters() {
        $formSet = new TestTask();

        //set location dir
        try {
            $formSet->setLogLocation('/bla/bla');
            $this->fail('exception was not throw') ;
        }catch(TaskInitException $exception){}
        try {
            $formSet->setLogLocation('/root');
            $this->fail('exception was not throw') ;
        }catch(TaskInitException $exception){}
        $formSet->setLogLocation('./tmp');

        //set logging file
        $formSet->setLogName('log.log');

        //set file size
        //$this->expectException(TaskInitException::class);
        try {
            $formSet->setMaxLogFileSize("asdf");
            $this->fail('exception was not throw') ;
        }catch(TaskInitException $exception){}
        try {
            $formSet->setMaxBackupLogFiles("asdf");
            $this->fail('exception was not throw') ;
        }catch(TaskInitException $exception){}
        $formSet->setMaxLogFileSize(10);
        $formSet->setMaxBackupLogFiles(10);

        //send emails
        $formSet->setSendEmails(true);

    }

    public function testErrorLog(){
        $task = $this->makeDefaultLogger();
        $task->publicInitTask();
        $task->error('error', new Exception());

        //check
        $logger = $task->getLoger();
        $this->assertTrue($logger->message == 'error', 'String is not matched');
        $logger = $task->getLoger();
        $this->assertTrue($logger->context['exception'] instanceof Exception, 'Class type is no valid');
    }

    public function testCriticalLog(){
        $task = $this->makeDefaultLogger();
        $task->publicInitTask();
        $task->fatal('fatal', new Exception());

        //check
        $logger = $task->getLoger();
        $this->assertTrue($logger->message == 'fatal', 'String is not matched');
        $logger = $task->getLoger();
        $this->assertTrue($logger->context['exception'] instanceof Exception, 'Class type is no valid');
    }

    public function testInfoLog(){
        $task = $this->makeDefaultLogger();
        $task->publicInitTask();
        $task->textToLog('test');

        //check
        $logger = $task->getLoger();
        $this->assertTrue($logger->message == 'test', 'String is not matched');
        $logger = $task->getLoger();
        $this->assertTrue($logger->context['exception'] == null, 'Error in test');
    }

    /**
     * @return TestTask
     */
    protected function makeDefaultLogger(){
        $obj = new TestTask();
        $obj->setLogLocation('./tmp');
        $obj->setLogName('log.log');
        return $obj;
    }

    protected function tearDown(){
        rmdir("./tmp");
    }

}

class TestTask extends LoggerTask{
    public function runTask() {

    }

    public function getLoger(){
        return $this->logger;
    }

    public function publicInitTask(){
        $this->logger = new TestLogger();
    }
}

class TestLogger extends Logger{
    public $message;
    public $context;

    public function __construct() {

    }

    public function error($message, array $context = []) {
        $this->message = $message;
        $this->context = $context;
    }

    public function info($message, array $context = []) {
        $this->message = $message;
        $this->context = $context;
    }

    public function critical($message, array $context = []) {
        $this->message = $message;
        $this->context = $context;
    }

}


