<?php

namespace IZON\Minifier\Tests;

use IZON\Minifier\Interfaces\PathPairInterface;
use IZON\Minifier\PathPair;
use PHPUnit\Framework\TestCase;

/**
 * Description of PathPairTest
 *
 * @author ales
 */
class PathPairTest extends TestCase {
    
    /**
     * 
     * @return PathPairInterface
     */
    protected function createPathPair() {
        $object = new PathPair([], '', 'css');
        return $object;
    }

    /**
     * @test
     */
    public function testGetFileType() {
        $pathPair = $this->createPathPair();
        $expected = [PathPair::FILE_TYPE_CSS, PathPair::FILE_TYPE_JS];
        $this->assertTrue(in_array($pathPair->getFileType(), $expected));
    }
    
    public function testGetSourceFiles() {
        $pathPair = $this->createPathPair();
        $this->assertTrue(is_array($pathPair->getSourceFiles()));
    }
    
    public function testGetTargetFile() {
        $pathPair = $this->createPathPair();
        $this->assertTrue(is_string($pathPair->getTargetFile()));
    }
    
    public function testGetTargetDir() {
        $pathPair = $this->createPathPair();
        $this->assertTrue(is_string($pathPair->getTargetDir()));
    }
    
    public function testIsJsFile() {
        $pathPair = $this->createPathPair();
        $this->assertTrue(is_bool($pathPair->isJsFile()));
    }
    
    public function testIsCssFile() {
        $pathPair = $this->createPathPair();
        $this->assertTrue(is_bool($pathPair->isCssFile()));
    }

}
