<?php

namespace IZON\Minifier;

use IZON\Minifier\Interfaces\MinifierServiceInterface;
use IZON\Minifier\Interfaces\PathPairInterface;
use MatthiasMullie\Minify\CSS;
use MatthiasMullie\Minify\JS;

/**
 * MinifierService
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class MinifierService implements MinifierServiceInterface {

    /**
     * 
     * @param MinifierConfig $config
     */
    public function minifyFiles(MinifierConfig $config) {
        #Minify JS files
        foreach($config->getPathPairs() as $pathPair) {
            $this->checkTargetDir($pathPair);
            $this->minifyFile($pathPair);
        }
    }
    
    /**
     * 
     * @param PathPairInterface $pathPair
     */
    protected function minifyFile(PathPairInterface $pathPair) {
        if($pathPair->isJsFile()) {
            $this->minifyJsFile($pathPair);
        } else if ($pathPair->isCssFile()) {
            $this->minifyCssFile($pathPair);
        }
    }
    
    /**
     * 
     * @param PathPairInterface $pathPair
     */
    protected function minifyCssFile(PathPairInterface $pathPair) {        
        $minifier = $this->createCssMinifier();        
        foreach($pathPair->getSourceFiles() as $srcFile) {
            $minifier->add($srcFile);
        }
        $minifier->minify($pathPair->getTargetFile());
    }

    /**
     * 
     * @param PathPairInterface $pathPair
     */
    protected function minifyJsFile(PathPairInterface $pathPair) {        
        $minifier = $this->createJsMinifier();        
        foreach($pathPair->getSourceFiles() as $srcFile) {
            $minifier->add($srcFile);
        }
        $minifier->minify($pathPair->getTargetFile());
    }
    
    /**
     * 
     * @return JS
     */
    protected function createJsMinifier(): JS{
        $mullieMinifier = new JS();
        return $mullieMinifier;
    }
    
    /**
     * 
     * @return CSS
     */
    protected function createCssMinifier(): CSS{
        $mullieMinifier = new CSS();
        return $mullieMinifier;
    }

    /**
     * Checks target dir for file, if not its created.
     * @param PathPairInterface $pathPair
     */
    protected function checkTargetDir(PathPairInterface $pathPair) {
        $targetDir = $pathPair->getTargetDir();
        if(!file_exists($targetDir)) {
            mkdir($targetDir, 0777, true);
        }
    }

}
