<?php

namespace IZON\Minifier;

use IZON\Minifier\Interfaces\MinifierServiceInterface;

/**
 * Description of MinifierRunner
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class MinifierRunner {
    /**
     *
     * @var MinifierConfig
     */
    protected $config;
    /**
     *
     * @var MinifierServiceInterface
     */
    protected $minifierService;

    /**
     * 
     * @param MinifierServiceInterface $minifierService
     */
    public function __construct(MinifierServiceInterface $minifierService) {
        $this->minifierService = $minifierService;
    }

    /**
     * 
     * @param array $pathPairs
     */
    public function setPathPairs($pathPairs) {
        $config = new MinifierConfig();
        foreach($pathPairs as $pair) {
            $config->addPathPair($pair); //$pair = ['sourceFiles' => ['path1', 'path2'], 'targetFile' => '']
        }
        $this->config = $config;
    }

    /**
     * Runs the minification process.
     */
    public function run() {
        $this->minifierService->minifyFiles($this->config);
    }
    
    /**
     * Creates default MinifierRunner.
     * @return MinifierRunner
     */
    public static function createDefault() {
        $service = new MinifierService();
        $runner = new static($service);
        return $runner;
    }

}
