<?php

namespace IZON\Minifier;

use IZON\Minifier\Exceptions\MinifierException;
use IZON\Minifier\Interfaces\PathPairInterface;

/**
 * MinifierConfig
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class MinifierConfig {
    /**
     *
     * @var array Array of PathPairInterface objects.
     */
    protected $pathPairs = [];

    /**
     * 
     * @return PathPairInterface[]
     */
    public function getPathPairs() {
        return $this->pathPairs;
    }

    /**
     * Adds path pair to config.
     * @param array $pair ['sourceFiles' => ['path1', 'path2'], 'targetFile' => '', 'fileType' => '']
     * @throws MinifierException
     */
    public function addPathPair(array $pair) {
        $this->validatePathPairArrayKeys($pair);
        # Source files exist
        foreach($pair['sourceFiles'] as $srcFile) {
            if(!file_exists($srcFile)) {
                throw new MinifierException("File {$pair['sourceFile']} does not exist.");
            }
        }
        # Add path pair
        $pathPair = new PathPair($pair['sourceFiles'], $pair['targetFile'], $pair['fileType']);
        $this->pathPairs[] = $pathPair;
    }
    
    /**
     * Checks if pair array has needed keys.
     * @param array $pair
     * @throws MinifierException
     */
    protected function validatePathPairArrayKeys(array $pair) {
        if(empty($pair)) {
            throw new MinifierException("Pair cannot be empty array.");
        }
        # Source files
        if(!isset($pair['sourceFiles'])) {
            throw new MinifierException("Source files key 'sourceFiles' is not set in array.");
        }
        if(!is_array($pair['sourceFiles'])) {
            throw new MinifierException("Source files value must be array.");
        }
        
        # Target file
        if(!isset($pair['targetFile'])) {
            throw new MinifierException("Target file key 'targetFile' is not set in array.");
        }
        if(!is_string($pair['targetFile'])) {
            throw new MinifierException("Target file value must be string.");
        }
        
        # File type
        if(!isset($pair['fileType'])) {
            throw new MinifierException("File type key 'fileType' is not set in array.");
        }
        if(!is_string($pair['fileType'])) {
            throw new MinifierException("File type value must be string.");
        }
        if(!in_array($pair['fileType'], [PathPair::FILE_TYPE_CSS, PathPair::FILE_TYPE_JS])) {
            throw new MinifierException("File type value is out of allowed range.");
        }
    }

}
