<?php
# Print out help info when "--help" parameter is set.
foreach($argv as $var) {
    if($var == '--help') {
        echo '  -  This script minifies static scripts.' . PHP_EOL;
        echo '  -  It does not need any configuration, it minifies files given by method $resolver->getStaticContentMinificationInfo() calling on view resolver. '. PHP_EOL;
        echo '  -  For more information visit git package readme page https://gitlab.olc.cz/izon/icore/scripts-minifier/blob/develop/README.md';
        die();
    }
}
/*******************************************************************************
 * 
 * PUT THIS FILE IN TOOLS FOLDER!!!
 * 
 * MINIFIER SCRIPT
 * Put this file into tools folder and run it from there.
 * 
 */

use IZON\Admin\Config;
use IZON\DI\Container;
use IZON\Minifier\MinifierRunner;
use IZON\MVC\Views\StaticContent\MifiableStaticContentInterface;

// set default file persissions to 0664 and folders with 0775
umask(0002);

$autoLoader = require __DIR__.'/../htdocs/vendor/autoload.php';

# Init Config
$baseDir = dirname(__DIR__).'/htdocs';
$config = new Config($baseDir);
try {
    $config->init();
} catch(\Exception $exception) {
    throw $exception;
}

# Get static content paths
/* @var $container Container */
$resolvers = $config->getViewResolvers();

$pathPairs = [];
foreach($resolvers as $resolver) {
    if($resolver instanceof MifiableStaticContentInterface) {
        /* @var $fileInfos \IZON\MVC\Views\StaticContent\FilesMinificationInfo[] */
        $fileInfos = $resolver->getStaticContentMinificationInfo();
        
        foreach($fileInfos as $fileInfo) {            
            $pair['sourceFiles'] = $fileInfo->getSourceFiles();
            $pair['targetFile'] = $fileInfo->getTargetDir().'/'.$fileInfo->getTargetFileName();
            $pair['fileType'] = $fileInfo->getFileType();
            $pathPairs[] = $pair;
        }   
    }
}

$runnerIdentifier = 'scriptsMinifier.runner';
# Get/create MinifierRunner
if($config->getContainer()->has($runnerIdentifier)) {
    /* @var $minifierRunner MinifierRunner */
    $minifierRunner = $config->getContainer()->get('scriptsMinifier.runner');
    echo '... MinifierRunner from config container is set.' . PHP_EOL;
} else {
    $minifierRunner = MinifierRunner::createDefault();
    echo '... Default MinifierRunner was created.' . PHP_EOL;
}
# Fetch by data
$minifierRunner->setPathPairs($pathPairs); 
echo '... Paths were successfully set.' . PHP_EOL;
# Execute minification process
$minifierRunner->run();
echo '... Scripts were successfully minified.' . PHP_EOL;