
Knihovna pro minifikaci JS i CSS souborů.

>>>
Soubor minifier.php je umístěn a spouštěn ze složky /tools.
>>>

Jejím vstupem je pole polí, kde jednotlivá pole v sobě nesou absolutní cestu ke zdrojovým souborům a cestu cílového souboru, do kterého
mají být zdrojové soubory sloučeny a uloženy.
Příklad vstupního pole do metody setPathPairs() objektu MinifierRunner:

```php
$pathPairs = [
    [
        'sourceFiles' => [
                            'path/to/source/file-1.js',
                            'path/to/source/file-2.js'
                        ],
        'targetFile' => 'path/to/target/file.js',
        'fileType' => 'js'
    ]
]
```

Ovládání knihovny se skládá ze dvou částí, kdy v první části nastavíme cesty pomocí výše uvedeného pole cest:
```php
$minifierRunner->setPathPairs($pathPairs); 
```

Ve druhé části spustíme samotnou minifikaci:
```php
$minifierRunner->run();
```

Obsluha knihovny je také vidět v souboru minifier.php, který v současné chvíli slouží pro získání cest z Configu aplikace a spuštěním knihovny.

Nastaveni DI pro knihovnu (pokud není toto nastavení v DI uvedeno, minifier vytvoří defaultní nastavení):
config.system.php:
```php
// SCRIPTS MINIFIER
'scriptsMinifier.runner' => object(IZON\Minifier\MinifierRunner::class)
        ->constructor(get('scriptsMinifier.service')),
'scriptsMinifier.service' => object(\IZON\Minifier\MinifierService::class),
```

Pro samotnou minifikaci souborů je nyní využívána knihovna https://github.com/matthiasmullie/minify.