<?php

namespace IZON\Minifier\Tests;

use IZON\Minifier\Exceptions\MinifierException;
use IZON\Minifier\Interfaces\MinifierServiceInterface;
use IZON\Minifier\MinifierConfig;
use IZON\Minifier\MinifierService;
use PHPUnit\Framework\TestCase;

/**
 * Description of MinifierServiceTest
 *
 * @author ales
 */
class MinifierServiceTest extends TestCase {
    
    /**
     * 
     * @return MinifierServiceInterface
     */
    protected function createMinifierService() {
        $service = new MinifierService();
        return $service;
    }

    public function testEmptyPathPair() {
        $this->expectException(MinifierException::class);
        $config = new MinifierConfig();
        $config->addPathPair([]);
    }
    
    public function testNonsensicalPathPair() {
        $this->expectException(MinifierException::class);        
        $config = new MinifierConfig();
        $config->addPathPair(['111', '222']);
    }

    public function testCorrectConfig() {
        $config = new MinifierConfig();
        $configArr = $this->getConfigArray();
        $config->addPathPair($configArr);
        /* @var $pathPair \IZON\Minifier\PathPair */
        $pathPair = reset($config->getPathPairs());
        
        $this->assertTrue(($pathPair->getTargetFile() == $configArr['targetFile']));
        $this->assertTrue(($pathPair->getFileType() == $configArr['fileType']));
    }
    
    /**
     * Returns correct config array.
     * @return array
     */
    protected function getConfigArray() {
        return [
            'sourceFiles' => [
                                __DIR__.'/sample-files/sample.js'
                            ],
            'targetFile' => __DIR__.'/sample-files/minified/sample.js',
            'fileType' => 'js'
        ];
    }
}
