<?php

namespace IZON\Minifier;

use IZON\Minifier\Interfaces\PathPairInterface;

/**
 * PathPair
 * Encapsulates paths for file.
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class PathPair implements PathPairInterface {    
    /**
     * Array of absolute paths to files on file system.
     * @var array Array of strings.
     */
    protected $sourceFiles;
    /**
     * Absolute path to file on file system.
     * @var string
     */
    protected $targetFile;
    /**
     * Type of file - use constants of PathPairInterface.
     * @var string
     */
    protected $fileType;
    /**
     * 
     * @param array $sourceFiles
     * @param string $targetFile
     */
    public function __construct(array $sourceFiles, $targetFile, $fileType) {
        $this->sourceFiles = $sourceFiles;
        $this->targetFile = $targetFile;
        $this->fileType = $fileType;
    }

    /**
     * @return array
     */
    public function getSourceFiles(): array{
        return $this->sourceFiles;
    }

    /**
     * @return string
     */
    public function getTargetFile(): string{
        return $this->targetFile;
    }
    
    /**
     * @return string
     */
    public function getFileType(): string{
        return $this->fileType;
    }

    /**
     * @return string
     */
    public function setSourceFiles(array $sourceFiles) {
        $this->sourceFiles = $sourceFiles;
    }

    /**
     * @return string
     */
    public function setTargetFile($targetFile) {
        $this->targetFile = $targetFile;
    }

    /**
     * Returns dir name of target file.
     * @return string
     */
    public function getTargetDir(): string{
        return dirname($this->targetFile);
    }
    
    /**
     * 
     * @return boolean
     */
    public function isCssFile(): bool {
        return $this->fileType === PathPairInterface::FILE_TYPE_CSS;
    }
    
    /**
     * 
     * @return boolean
     */
    public function isJsFile(): bool {
        return $this->fileType === PathPairInterface::FILE_TYPE_JS;
    }

}
