<?php

namespace IZON\Polyfill\Tracy;

use IZON\Logs\LoggerRegistry;
use Psr\Log\LoggerInterface;

class Debugger {

    /** server modes for Debugger::enable() */
    public const
        Development = false,
        Production = true,
        Detect = null;

    public static ?bool $productionMode = self::Detect;

    /** determines whether any error will cause immediate death in development mode; if integer that it's matched against error severity */
    public static bool|int $strictMode = false;

    /** how many nested levels of array/object properties display by dump() */
    public static int $maxDepth = 15;

    /** how long strings display by dump() */
    public static int $maxLength = 150;

    /** name of the directory where errors should be logged */
    public static ?string $logDirectory = null;


    public static function __callStatic(string $name, array $arguments) {
        self::getLogger()->error(
            'Tracy/Debugger method called in production environment',
            [
                'method' => $name,
                'arguments' => $arguments,
                'stackTrace' => debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS)
            ]
        );
    }

    protected static function getLogger(): LoggerInterface {
        static $logger;
        if($logger === null) {
            $logger = LoggerRegistry::getLogger('tracy');
        }
        return $logger;
    }
}
