<?php


namespace IZON\PHPStan\Tests\Rules;

use IZON\PHPStan\Rules\DateTimeConstructorRule;
use PHPStan\Rules\Rule;
use PHPStan\Testing\RuleTestCase;

/**
 * @extends RuleTestCase<DateTimeConstructorRule>
 */
class DateTimeConstructorRuleTest extends RuleTestCase
{
    protected function getRule(): Rule
    {
        return new DateTimeConstructorRule();
    }

    public function testRule(): void
    {
        $message = 'Do not call New DateTime/DateTimeImmutable with parameters. Can cause hard to find bugs.';
        $tip = 'Use (DateTime|DateTimeImmutabl)::createFromFormat() method or IZON\Date\(DateTimeFactory|DateTimeImmutableFactory) methods.';

        // first argument: path to the example file that contains some errors that should be reported by MyRule
        // second argument: an array of expected errors,
        // each error consists of the asserted error message, and the asserted error file line
        $this->analyse(
            [__DIR__ . '/../date-constructor.php'],
            [
                [
                    $message,
                    3, // asserted error line
                    $tip
                ],
                [
                    $message,
                    5, // asserted error line
                    $tip
                ],
            ]
        );

        // the test fails, if the expected error does not occur,
        // or if there are other errors reported beside the expected one
    }
}
