<?php

namespace IZON\PHPStan\Rules;

use DateTime;
use DateTimeImmutable;
use PhpParser\Node;
use PhpParser\Node\Expr\New_;
use PhpParser\Node\Name;
use PHPStan\Analyser\Scope;
use PHPStan\Rules\Rule;
use PHPStan\Rules\RuleError;
use PHPStan\Rules\RuleErrorBuilder;

/**
 * @implements Rule<New_>
 */
class DateTimeConstructorRule implements Rule
{
    public function getNodeType(): string
    {
        return New_::class;
    }

    /**
     * @param New_ $node
     * @param Scope $scope
     * @return array<int, string|RuleError>
     */
    public function processNode(Node $node, Scope $scope): array
    {
        if (!$node->class instanceof Name) {
            return [];
        }

        if (
            $node->class->toString() !== DateTime::class
            && $node->class->toString() !== DateTimeImmutable::class
        ) {
            return [];
        }

        if (count($node->getRawArgs()) == 0) {
            return [];
        }

        $ruleBuilder = RuleErrorBuilder::message(
            'Do not call New DateTime/DateTimeImmutable with parameters. Can cause hard to find bugs.'
        )->tip('Use (DateTime|DateTimeImmutabl)::createFromFormat() method or IZON\Date\(DateTimeFactory|DateTimeImmutableFactory) methods.');

        return [
            $ruleBuilder->build()
        ];
    }
}
