<?php

$vendorDir = dirname($GLOBALS['_composer_bin_dir'], 1);

return [
    'includes' => [
        $vendorDir .'/spaze/phpstan-disallowed-calls/extension.neon',
    ],
    'parameters' => [
        'editorUrl' => 'editor://open/?file=%%file%%&line=%%line%%',
        'disallowedFunctionCalls' => [
            [
                'function' => 'var_dump',
                'message' => 'Do not leave var_dump in code',
            ],
            [
                'function' => 'print_r',
                'message' => 'Do not leave print_r in code',
            ],
            [
                'function' => 'dump',
                'message' => 'Do not leave dump in code',
            ],
            [
                'function' => 'dumpe',
                'message' => 'Do not leave dumpe in code',
            ],
            [
                'function' => 'bdump',
                'message' => 'Do not leave bdump in code',
            ],
            [
                'function' => '\PHPStan\dumpType',
                'message' => 'Do not leave dumpType in code',
            ],

        ],
        'disallowedNamespaces' => [
            [
                'class' => 'Tracy\*',
                'message' => 'Do not leave Tracy in code',
            ],
        ],
    ],
];
