<?php

namespace IZON\PaymentGate\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Description of PaymentGateTransaction
 * @author IZON s.r.o. <info@izon.cz>
 */
#[ORM\Entity]
class PaymentGateTransaction
{
    //transaction is created
    public const STATUS_NEW = "new";

    //transation is sended to gate
    public const STATUS_SEND = "send";

    //transation faild send to gate
    public const STATUS_SEND_FAILD = "send_faild";

    //transaction is received from gate
    public const STATUS_RECEIVE = "receive";

    //transation waiting for payment
    public const STATUS_WAITING_FOR_PAYMENT = "waiting_for_payment";

    //payment received
    public const STATUS_PAYMENT_RECEIVED = "payment_received";

    //payment not received
    public const STATUS_PAYMENT_NOT_RECEIVED = "payment_not_received";

    //transaction was canceled
    public const STATUS_STORNO = "payment_storno";

    //Unexpected error
    public const STATUS_ERROR = "error";

    //sucess - payment was been serverd
    public const STATUS_SUCCESS = "sucess";

    /**
     * @var int|null
     */
    #[ORM\Column]
    #[ORM\GeneratedValue]
    #[ORM\Id]
    protected ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column]
    protected string $code = '';

    /**
     * @var PaymentGate|null
     */
    #[ORM\JoinColumn(name: 'fk_payment_gate_id', referencedColumnName: 'id')]
    #[ORM\ManyToOne(targetEntity: PaymentGate::class)]
    protected ?PaymentGate $paymentGate = null;

    /**
     * @var int|null
     */
    #[ORM\Column]
    protected ?int $fkOrderId = null;

    /**
     * @var string
     */
    #[ORM\Column]
    protected string $status = '';

    /**
     * @var Collection<int, PaymentGateTransactionProcess>
     */
    #[ORM\OneToMany(targetEntity: PaymentGateTransactionProcess::class, mappedBy: 'paymentGateTransaction', cascade: ['persist'])]
    protected Collection $processes;

    /**
     * PaymentGateTransaction constructor.
     */
    public function __construct()
    {
        $this->processes = new ArrayCollection();
    }

    /**
     * @param string $status status of transaction
     * @param string $data actual data
     * @param string $description description of data
     */
    public function setStatus($status, $data, $description = "")
    {
        $this->status = $status;
        $nextProcess = new PaymentGateTransactionProcess();
        $nextProcess->setStatus($status);
        $nextProcess->setData($data);
        $nextProcess->setDescription($description);
        $nextProcess->setPaymentGateTransaction($this);
        $this->processes[] = $nextProcess;
    }

    /**
     * @param string $status
     * @return PaymentGateTransactionProcess|null
     */
    public function getStatusData($status)
    {
        $process = $this->processes->filter(function ($process) use ($status) {
            return $process->getStatus() == $status;
        })->first();
        if ($process !== false) {
            return $process;
        }
        return null;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return PaymentGate|null
     */
    public function getPaymentGate(): ?PaymentGate
    {
        return $this->paymentGate;
    }

    /**
     * @param PaymentGate|null $paymentGate
     */
    public function setPaymentGate(?PaymentGate $paymentGate): void
    {
        $this->paymentGate = $paymentGate;
    }

    /**
     * @return int|null
     */
    public function getFkOrderId(): ?int
    {
        return $this->fkOrderId;
    }

    /**
     * @param int|null $fkOrderId
     */
    public function setFkOrderId(?int $fkOrderId): void
    {
        $this->fkOrderId = $fkOrderId;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }
}
