<?php

namespace IZON\PaymentGate\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * Description of PaymentGate
 * @author IZON s.r.o. <info@izon.cz>
 */
#[ORM\Entity]
class PaymentGate
{
    /**
     * @var int|null
     */
    #[ORM\Column]
    #[ORM\GeneratedValue]
    #[ORM\Id]
    protected ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column]
    protected string $name;

    /**
     * @var class-string
     */
    #[ORM\Column]
    protected string $classname;

    /**
     * @var string|null
     */
    #[ORM\Column]
    protected ?string $description;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getClassname(): string
    {
        return $this->classname;
    }

    /**
     * @param string $classname
     */
    public function setClassname(string $classname): void
    {
        $this->classname = $classname;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }
}
