<?php

namespace IZON\PaymentGate\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use IZON\DB\DBObject;

/**
 * Description of PaymentGateTransaction
 * @author IZON s.r.o. <info@izon.cz>
 * @ORM\Entity()
 */
class PaymentGateTransaction {
    //transaction is created
    CONST STATUS_NEW = "new";
    //transation is sended to gate
    CONST STATUS_SEND = "send";
    //transation faild send to gate
    CONST STATUS_SEND_FAILD = "send_faild";
    //transaction is received from gate
    CONST STATUS_RECEIVE = "receive";
    //transation waiting for payment
    CONST STATUS_WAITING_FOR_PAYMENT = "waiting_for_payment";
    //payment received
    CONST STATUS_PAYMENT_RECEIVED = "payment_received";
    //payment not received
    CONST STATUS_PAYMENT_NOT_RECEIVED = "payment_not_received";
    //transaction was canceled
    CONST STATUS_STORNO = "payment_storno";
    //Unexpected error
    CONST STATUS_ERROR = "error";
    //sucess - payment was been serverd
    CONST STATUS_SUCCESS = "sucess";
    /**
     * @ORM\Column
     * @ORM\GeneratedValue
     * @ORM\Id
     * @var int|null
     */
    protected $id;
    /**
     * @ORM\Column
     * @var string
     */
    protected $code;
    /**
     * @ORM\ManyToOne(targetEntity="PaymentGate")
     * @ORM\JoinColumn(name="fk_payment_gate_id", referencedColumnName="id")
     * @var PaymentGate|null
     */
    protected $paymentGate;
    /**
     * @ORM\Column
     * @var int|null
     */
    protected $fkOrderId;
    /**
     * @ORM\Column
     * @var string
     */
    protected $status;
    /**
     * @ORM\OneToMany(targetEntity="PaymentGateTransactionProcess", mappedBy="paymentGateTransaction", cascade={"persist"})
     * @var PaymentGateTransactionProcess[]
     */
    protected $processes;

    /**
     * PaymentGateTransaction constructor.
     */
    public function __construct() {
        $this->processes = new ArrayCollection();
    }

    /**
     * @param string $status status of transaction
     * @param $data string actual data
     * @param string $description description of data
     */
    public function setStatus($status, $data, $description = "") {
        $this->status = $status;
        $nextProcess = new PaymentGateTransactionProcess();
        $nextProcess->setStatus($status);
        $nextProcess->setData($data);
        $nextProcess->setDescription($description);
        $nextProcess->setPaymentGateTransaction($this);
        $this->processes[] = $nextProcess;
    }

    /**
     * @param string $status
     * @return PaymentGateTransactionProcess|null
     */
    public function getStatusData($status) {
        $process = $this->processes->filter(function($process) use ($status) {
            return $process->getStatus() == $status;
        })->first();
        if($process !== false) {
            return $process;
        }
        return null;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void {
        $this->code = $code;
    }

    /**
     * @return PaymentGate|null
     */
    public function getPaymentGate(): ?PaymentGate {
        return $this->paymentGate;
    }

    /**
     * @param PaymentGate|null $paymentGate
     */
    public function setPaymentGate(?PaymentGate $paymentGate): void {
        $this->paymentGate = $paymentGate;
    }

    /**
     * @return int|null
     */
    public function getFkOrderId(): ?int {
        return $this->fkOrderId;
    }

    /**
     * @param int|null $fkOrderId
     */
    public function setFkOrderId(?int $fkOrderId): void {
        $this->fkOrderId = $fkOrderId;
    }

    /**
     * @return string
     */
    public function getStatus(): string {
        return $this->status;
    }


}
