<?php

namespace IZON\PaymentGate\Interfaces;

use IZON\MVC\Messages\HttpRequestInterface;
use IZON\PaymentGate\Classes\Setting;
use IZON\PaymentGate\Domain\PaymentGate;
use IZON\PaymentGate\Domain\PaymentGateTransaction;
use IZON\PaymentGate\Services\BasePaymentGateService;

interface ISimpleGate {

    /**
     * ISimpleGate constructor.
     * @param Setting $setting
     * @param BasePaymentGateService $paymentService
     */
    public function __construct(Setting $setting, BasePaymentGateService $paymentService, PaymentGate $paymentGate);

    /**
     * Returns PaymentGate object.
     * @return PaymentGate
     */
    public function getPaymentGate(): PaymentGate;

    /**
     * Create payment of gate and return url to redirect
     * @param $order
     * @param HttpRequestInterface $request
     * @return string URL of payment gate for redirection.
     */
    public function createTransaction($order, HttpRequestInterface $request) : string;

    /**
     * Parse request
     * @param HttpRequestInterface $request
     * @return PaymentGateTransaction|null
     */
    public function parseReturn(HttpRequestInterface $request): ?PaymentGateTransaction;

    /**
     * Return transaction object by request
     * @param HttpRequestInterface $request
     * @return PaymentGateTransaction|null
     */
    public function getTransactionByRequest(HttpRequestInterface $request): ?PaymentGateTransaction;

}
