<?php

namespace IZON\PaymentGate\Factories;

use IZON\PaymentGate\Domain\PaymentGateTransaction;
use IZON\PaymentGate\Interfaces\IGatePayable;
use IZON\PaymentGate\Interfaces\ISimpleGate;

class PaymentGateFactory {

    /**
     * @param IGatePayable $gatePayable
     * @param ISimpleGate $gate
     * @param string $status
     * @param string|null $data
     * @param string|null $description
     * @return PaymentGateTransaction
     */
    public static function createPaymentGateTransaction(IGatePayable $gatePayable, ISimpleGate $gate, string $status, ?string $data = "", ?string $description = ""): PaymentGateTransaction{
        $transaction = new PaymentGateTransaction();

        $transaction->setCode($gatePayable->getIdentifier());
        $transaction->setFkOrderId($gatePayable->getIdentifier());
        $transaction->setPaymentGate($gate->getPaymentGate());
        $transaction->setStatus($status, $data, $description);

        return $transaction;
    }

}