<?php

namespace IZON\PaymentGate\Domain;

use IZON\DB\DBObject;
use IZON\IO\Image;
use Doctrine\ORM\Mapping as ORM;

/**
 * Description of PaymentGateTransactionProcess
 * @author IZON s.r.o. <info@izon.cz>
 * @ORM\Entity
 * @ORM\Table(name="payment_gate_transaction_processes")
 */
class PaymentGateTransactionProcess {
    /**
     * @ORM\Column
     * @ORM\GeneratedValue
     * @ORM\Id
     * @var int|null
     */
    protected $id;
    /**
     * @ORM\ManyToOne(targetEntity="PaymentGateTransaction")
     * @ORM\JoinColumn(name="fk_payment_gate_transaction_id", referencedColumnName="id")
     * @var PaymentGateTransaction|null
     */
    protected $paymentGateTransaction;
    /**
     * @ORM\Column
     * @var string
     */
    protected $status;
    /**
     * @ORM\Column
     * @var string
     */
    protected $data;
    /**
     * @ORM\Column
     * @var string
     */
    protected $description;

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void {
        $this->id = $id;
    }

    /**
     * @return PaymentGateTransaction|null
     */
    public function getPaymentGateTransaction(): ?PaymentGateTransaction {
        return $this->paymentGateTransaction;
    }

    /**
     * @param PaymentGateTransaction|null $paymentGateTransaction
     */
    public function setPaymentGateTransaction(?PaymentGateTransaction $paymentGateTransaction): void {
        $this->paymentGateTransaction = $paymentGateTransaction;
    }

    /**
     * @return string
     */
    public function getStatus(): string {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status): void {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getData(): string {
        return $this->data;
    }

    /**
     * @param string $data
     */
    public function setData(string $data): void {
        $this->data = $data;
    }

    /**
     * @return string
     */
    public function getDescription(): string {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description): void {
        $this->description = $description;
    }

}
