<?php

namespace IZON\PaymentGate\Services;


use IZON\DB\EntityManagerInterface;
use IZON\DB\Repository\BaseRepository;
use IZON\PaymentGate\Domain\PaymentGate;
use IZON\PaymentGate\Domain\PaymentGateTransaction;
use IZON\PaymentGate\Domain\PaymentGateTransactionProcess;

abstract class BasePaymentGateService{

    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    /**
     * @var BaseRepository
     */
    protected $paymentGateRepository;
    /**
     * @var BaseRepository
     */
    protected $paymentGateTransactionRepository;
    /**
     * @var BaseRepository
     */
    protected $paymentGateTransactionProcessRepository;
    /**
     * BasePaymentGateService constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
        $this->paymentGateRepository = $entityManager->getRepository(PaymentGate::class);
        $this->paymentGateTransactionRepository = $entityManager->getRepository(PaymentGateTransaction::class);
        $this->paymentGateTransactionProcessRepository = $entityManager->getRepository(PaymentGateTransactionProcess::class);
    }

    /**
     * @param int $id
     * @return PaymentGate|null
     */
    public function getPaymentGate(int $id): ?PaymentGate{
        return $this->paymentGateRepository->find($id);
    }

    /**
     * @param PaymentGateTransaction $transaction
     */
    public function saveTransaction(PaymentGateTransaction $transaction): void {
        $this->entityManager->persist($transaction);
        $this->entityManager->flush();
    }

    /**
     * @param PaymentGateTransaction $transaction
     */
    public function updateTransaction(PaymentGateTransaction $transaction) {
        $this->entityManager->flush();
    }

    /**
     * @param PaymentGate $payGate
     * @return PaymentGateTransaction|null
     */
    public function getTransactionsByPayGate(PaymentGate $payGate): ?PaymentGateTransaction {
        return $this->paymentGateTransactionRepository
            ->findBy(["paymentGate" => $payGate->getId()]);
    }

    /**
     * @param $code
     * @return PaymentGateTransaction|null
     */
    public function getTransactionByCode($code): ?PaymentGateTransaction {
        return $this->paymentGateTransactionRepository
            ->findOneBy(["code" => $code]);
    }


}
