<?php

namespace IZON\PaymentGate\Interfaces;


use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\PaymentGate\Classes\Setting;
use IZON\PaymentGate\Domain\PaymentGateTransaction;
use IZON\PaymentGate\Services\BasePaymentGateService;

interface ISimpleGate {

    /**
     * ISimpleGate constructor.
     * @param Setting $setting
     * @param BasePaymentGateService $paymentService
     */
    public function __construct(Setting $setting, BasePaymentGateService $paymentService);

    /**
     * Create payment of gate and return url to redirect
     * @param $order
     * @return string url to redirect
     */
    public function createTransaction($order, HttpRequest $request);

    /**
     * Parse request
     * @param HttpRequest $request
     * @return PaymentGateTransaction
     */
    public function parseReturn(HttpRequest $request);

    /**
     * Return transaction object by request
     * @param HttpRequest $request
     * @return PaymentGateTransaction
     */
    public function getTransactionByRequest(HttpRequest $request);

}