# ------------------------------ TABLE STRUCTURES ------------------------------
# PAYMENT GATES
CREATE TABLE `payment_gates` (
  `id` bigint(20) NOT NULL,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `classname` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `payment_gates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);
ALTER TABLE `payment_gates`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

# PAYMENT GATES TRANSACTIONS
CREATE TABLE `payment_gate_transations` (
  `id` bigint(20) NOT NULL,
  `code` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `fk_payment_gate_id` bigint(20) NOT NULL,
  `fk_order_id` bigint(20) NOT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL COMMENT 'status of transaction',
  `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `payment_gate_transations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code_2` (`code`),
  ADD KEY `fk_payment_gate_id` (`fk_payment_gate_id`),
  ADD KEY `fk_order_id` (`fk_order_id`);
ALTER TABLE `payment_gate_transations`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
ALTER TABLE `payment_gate_transations`
  ADD CONSTRAINT `payment_gate_transations_ibfk_1` FOREIGN KEY (`fk_payment_gate_id`) REFERENCES `payment_gates` (`id`),
  ADD CONSTRAINT `payment_gate_transations_ibfk_2` FOREIGN KEY (`fk_order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

# PAYMENT GATES TRANSACTION PROCESS
CREATE TABLE `payment_gate_transation_process` (
  `id` bigint(20) NOT NULL,
  `fk_payment_transaction_id` bigint(20) NOT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `payment_gate_transation_process`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_payment_transaction_id` (`fk_payment_transaction_id`);
ALTER TABLE `payment_gate_transation_process`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
ALTER TABLE `payment_gate_transation_process`
  ADD CONSTRAINT `payment_gate_transation_process_ibfk_1` FOREIGN KEY (`fk_payment_transaction_id`) REFERENCES `payment_gate_transations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

# ------------------------------ DATA INSERTS ------------------------------
# mvc structure inserts
INSERT INTO `core_mvc_structure_cz` (`id`, `parent_id`, `parent_index`, `routes_order`, `controller_uid`, `method_name`, `short_title`, `title`, `description`, `keywords`, `robots`, `url`, `output_url`, `enabled`, `visible`, `one_way`, `update_timestamp`, `create_timestamp`) 
VALUES (NULL, NULL, '0', '0', 'web.gateController', 'returned', 'paymentGate', 'paymentGate', 'paymentGate', NULL, '', '^/paygate-return-(?P<id>[0-9]+)$', '^/paygate-return-(id)$', '1', '1', '0', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

INSERT INTO `core_mvc_structure_cz` (`id`, `parent_id`, `parent_index`, `routes_order`, `controller_uid`, `method_name`, `short_title`, `title`, `description`, `keywords`, `robots`, `url`, `output_url`, `enabled`, `visible`, `one_way`, `update_timestamp`, `create_timestamp`) 
VALUES (NULL, NULL, '0', '0', 'web.gateRePayController', NULL, 'Gate repay', 'Gate repay', 'Gate repay', NULL, '', '^/platebni-brana-opakovana-platba-(?P<orderNumber>[a-zA-Z0-9]+)-(?P<hash>[a-zA-Z0-9]+)$', '/platebni-brana-opakovana-platba-(orderNumber)-(hash)', '1', '1', '0', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

INSERT INTO `core_mvc_structure_cz` (`id`, `parent_id`, `parent_index`, `routes_order`, `controller_uid`, `method_name`, `short_title`, `title`, `description`, `keywords`, `robots`, `url`, `output_url`, `enabled`, `visible`, `one_way`, `update_timestamp`, `create_timestamp`) 
VALUES (NULL, NULL, '0', '0', 'web.gateRePayController', 'repay', 'Gate repay', 'Gate repay', 'Gate repay', NULL, '', '^/platebni-brana-opakovana-platba-execute-(?P<orderNumber>[a-zA-Z0-9]+)-(?P<hash>[a-zA-Z0-9]+)$', '/platebni-brana-opakovana-platba-execute-(orderNumber)-(hash)', '1', '1', '0', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

# payment gates table content
INSERT INTO `payment_gates` (`id`, `name`, `classname`, `description`, `create_timestamp`, `update_timestamp`) 
VALUES (NULL, 'ThePay', 'IZON\\AppModules\\Orders\\PaymentGate\\ThePay', '', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);