<?php

namespace IZON\PaymentGate\Services;


use IZON\MVC\Config;
use IZON\PaymentGate\Classes\Setting;
use IZON\PaymentGate\Exceptions\Exception;
use IZON\PaymentGate\Exceptions\PaymentException;
use IZON\PaymentGate\Interfaces\ISimpleGate;

class PaymentGateService extends  BasePaymentGateService {

    /**
     * Find payment gate in db by Id
     * Create class of ISimpleGate by classname in db
     *
     * @see ISimpleGate
     * @param $id
     * @return null| ISimpleGate
     * @throws PaymentException
     */
    public function createPaymentGate($id){
        try {
            $paymentGate = parent::getPaymentGate($id);
        }catch(\Exception $e){
            return null;
        }
        $className = $paymentGate->getClassname();
        if(!class_exists($className)){
            throw new PaymentException('PaymentGate Service class \'' . $className . '\' is not exist');
        }
        $settings = Config::getValue(Setting::CONFIG_PREFIX);
        $gateSetting = $settings[$id];
        if(empty($gateSetting)){
            throw new PaymentException('Setting for PaymentGate \'' . $className . '\' is not exist');
        }
        $gate = new $className($gateSetting, $this);
        if(!$gate instanceof ISimpleGate){
            throw new PaymentException('\'' . $className . '\' is not implement gate interface');
        }
        return $gate;
    }
}