<?php

namespace IZON\PaymentGate\Domain;

use IZON\DB\DBObject;
use function IZON\DB\transientField;
use IZON\Utils\Date;
use IZON\IO\Image;
use IZON\IO\File;

/**
 * Description of PaymentGateTransaction
 * @author IZON s.r.o. <info@izon.cz>
 */
class PaymentGateTransaction implements DBObject {
    //transaction is created
    CONST STATUS_NEW = "new";
    //transation is sended to gate
    CONST STATUS_SEND = "send";
    //transation faild send to gate
    CONST STATUS_SEND_FAILD = "send_faild";
    //transaction is received from gate
    CONST STATUS_RECEIVE = "receive";
    //transation waiting for payment
    CONST STATUS_WAITING_FOR_PAYMENT = "waiting_for_payment";
    //payment received
    CONST STATUS_PAYMENT_RECEIVED = "payment_received";
    //payment not received
    CONST STATUS_PAYMENT_NOT_RECEIVED = "payment_not_received";
    //transaction was canceled
    CONST STATUS_STORNO = "payment_storno";
    //Unexpected error
    CONST STATUS_ERROR = "error";
    //sucess - payment was been serverd
    CONST STATUS_SUCCESS = "sucess";
    /**
     *
     * @var integer
     */
    protected $id;
    /**
     * @var string
     */
    protected $code;
    /**
     *
     * @var integer
     */
    protected $fkPaymentGateId;
    /**
     *
     * @var integer
     */
    protected $fkOrderId;
    /**
     *
     * @var string
     */
    protected $status;
    /**
     * @var PaymentGateTransactionProcess[]
     */
    protected $process;


    public function __construct() {
    }

    public static function __process() {
        return transientField();
    }

    /**
     *
     */
    public static function __tableName() {
        return 'payment_gate_transations';
    }

    public function __toString() {
        return "Id:`".$this->id."`".";"."FkPaymentGateId:`".$this->fkPaymentGateId."`".";"."FkOrderId:`".$this->fkOrderId."`".";"."Status:`".$this->status."`".";";
    }

    /**
     *
     * @return integer
     */
    public function getId() {
        return $this->id;
    }
    /**
     *
     * @return integer
     */
    public function getFkPaymentGateId() {
        return $this->fkPaymentGateId;
    }
    /**
     *
     * @return integer
     */
    public function getFkOrderId() {
        return $this->fkOrderId;
    }
    /**
     *SETTERS
     */
    public function setId($input) {
        $this->id = $input;
    }

    public function setFkPaymentGateId($input) {
        $this->fkPaymentGateId = $input;
    }

    public function setFkOrderId($input) {
        $this->fkOrderId = $input;
    }

    /**
     * @param string $status status of transaction
     * @param $data string actual data
     * @param string $description description of data
     */
    public function setStatus($status, $data, $description = ""){
        $this->status = $status;
        $nextProcess = new PaymentGateTransactionProcess();
        $nextProcess->setStatus($status);
        $nextProcess->setData($data);
        $nextProcess->setDescription($description);
        $nextProcess->setFkPaymentTransactionId($this->id);
        $this->process[] = $nextProcess;
    }

    /**
     * @return string
     */
    public function getCode() {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode($code): void {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getStatus(): string {
        return $this->status;
    }

    /**
     * @return PaymentGateTransactionProcess[]
     */
    public function getProcess(): array {
        return $this->process;
    }

    /**
     * @param PaymentGateTransactionProcess[] $process
     */
    public function setProcess(array $process): void {
        $this->process = $process;
    }




}
