<?php

namespace IZON\PaymentGate\Factories;

use IZON\PaymentGate\Domain\PaymentGateTransaction;

class PaymentGateFactory {

    /**
     * @param integer $orderId
     * @param integer $gateId
     * @param string $status actual status of transaction
     * @param string $data
     * @param string $description
     * @return PaymentGateTransaction
     */
    public static function createPaymentGateTransation($orderId, $gateId, $status, $data = "", $description = ""){
        $transaction = new PaymentGateTransaction();
        $transaction->setCode(uniqid($orderId.$gateId));
        $transaction->setFkOrderId($orderId);
        $transaction->setFkPaymentGateId($gateId);
        $transaction->setStatus($status, $data, $description);

        return $transaction;
    }
}