<?php

namespace IZON\MVC;

/**
 * flash message object to store text and additional info about flash message
 */
class FlashMessage {
    
    /**
     * OK message with some information
     */
    const LEVEL_OK = 'OK';
    
    /**
     * non-critical error
     */
    const LEVEL_WARNING = 'WARNING';
    
    /**
     * critical error
     */
    const LEVEL_ERROR = 'ERROR';
    
    /**
     * @var string message to be displayed
     */
    protected $messageText;
    
    /**
     * @var string type of message, allows to query only some type of messages on frontend
     */
    protected $type;
    
    /**
     * @var string [OK|WARNING|ERROR] level of message
     */
    protected $level;
    
    /**
     * @param string $messageText text to be displayed
     * @param string $type type of message that allows to identify or obrain only some type of message
     * @param string $level [OK|WARNING|ERROR] level of message
     */
    public function __construct(string $messageText, ?string $type = null, $level = FlashMessage::LEVEL_OK) {
        $this->messageText = $messageText;
        $this->type = $type;
        $this->level = $level;
    }

    /**
     * @return string message
     */
    public function getMessageText(): string {
        return $this->messageText;
    }

    /**
     * @return string type of message
     */
    public function getType(): ?string {
        return $this->type;
    }

    public function getLevel(): string {
        return $this->level;
    }

    /**
     * OK message with some information
     * @return bool
     */
    public function isOk(): bool {
        return $this->level == self::LEVEL_OK;
    }

    /**
     * is non-critical error
     * @return bool
     */
    public function isWarning(): bool {
        return $this->level == self::LEVEL_WARNING;
    }

    /**
     * is critical error
     * @return bool
     */
    public function isError(): bool {
        return $this->level == self::LEVEL_ERROR;
    }
}
