<?php


namespace IZON\MVC\Interceptors;


use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\MVC\ModelAndView;

class CompatibleWrapperInterceptor implements InterceptorInterface {
    /**
     * @var Interceptor
     */
    protected $innerInterceptor;

    /**
     * CompatibleWrapperInterceptor constructor.
     * @param Interceptor $innerInterceptor
     */
    public function __construct(Interceptor $innerInterceptor) {
        $this->innerInterceptor = $innerInterceptor;
    }


    public function preHandle(HttpRequestInterface $request) : HttpRequestInterface {
        $return = $this->innerInterceptor->preHandle($request);
        if(!empty($return)) {
            $request = $request->withAttribute(PreHandleResult::class, $return);
        }
        return $request;
    }

    public function postHandle(HttpRequestInterface $request, HttpResponseInterface $response) : HttpResponseInterface {
        $mav =  $response->getModelAndView();
        if(empty($mav)) {
            $mav = new ModelAndView('DUMMY');
        }
        $this->innerInterceptor->postHandle($request, $mav);
        return $response;
    }

    public function afterCompletion(HttpRequestInterface $request, HttpResponseInterface $response, $exception) : HttpResponseInterface{
        $this->innerInterceptor->afterCompletion($request, $exception);
        return $response;
    }

}
