<?php

namespace IZON\MVC\Context;

use IZON\MVC\FlashMessage;
use IZON\MVC\HttpSession;
use IZON\MVC\Session\SessionInterface;
use IZON\Utils\Locale;
use Exception;

/**
 * context containing information about web i.e. is part of web, admin ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\MVC\Context
 */
interface ContextInterface {
    
    public function getSession(): SessionInterface;
    
    /**
     * pro controller s id $controllerId najde adresu pres kterou je ho mozno volat
     * @param string $controllerId id controlleru
     * @param array $parameters parametry, ptere se maji predat do adresy
     * @param string $methodName nazev metody, ktera se ma na controlleru zavolat
     * @param Locale $locale
     * @return string
     * @throws Exception
     */
    function getControllerURL(
            string $controllerId, 
            array $parameters = [], 
            $methodName = NULL, 
            $locale = NULL
        );
    
    /**
     * adds flash message to context
     * @param string $messageText text of flash message
     * @param string|null $type type of flash message it can be obtained under
     * @param string $level [OK|WARNING|ERROR] urgency of message
     */
    public function addFlashMessage(
            string $messageText, 
            string $type = null, 
            $level = FlashMessage::LEVEL_OK
        ): void;
    
    /**
     * get flash messages of only slecific type and removes them from context
     * 
     * @param string $type
     * @return FlashMessage[]
     */
    public function popFlashMessages(string $type): array;
    
    /**
     * returns all currenlt stored flash messages  and removes them from context
     * @return FlashMessage[]
     */
    public function popAllFlashMessages(): array;
}
