<?php

namespace IZON\MVC\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\MVC\Session\SessionProvider;


/**
 * initializes session in SessionProvider from HttpRequest session
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class SessionProviderInterceptor implements Interceptor {

    /**
     * @var SessionProvider
     */
    protected $sessionProvider;


    public function __construct(SessionProvider $sessionProvider) {
        $this->sessionProvider = $sessionProvider;
    }

    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        
    }

    public function preHandle(HttpRequest $request) {
        $session = $request->getSession();
        $this->sessionProvider->setSession($session);
    }

}
