<?php

namespace IZON\MVC\Factories;

use GuzzleHttp\Psr7\CachingStream;
use GuzzleHttp\Psr7\LazyOpenStream;
use IZON\MVC\Messages\HttpRequest;
use Psr\Http\Message\ServerRequestInterface;


class ServerRequestFactory {

    /**
     *
     * @param string $method
     * @param type $uri
     * @param array $serverParams
     * @return ServerRequestInterface
     */
    public function createServerRequest($method, $uri, array $serverParams = []): ServerRequestInterface {
        $headers = getallheaders();
        $body = new CachingStream(new LazyOpenStream('php://input', 'r+'));
        $protocolVersion = isset($_SERVER['SERVER_PROTOCOL']) ? str_replace('HTTP/', '', $_SERVER['SERVER_PROTOCOL']) : '1.1';

        $serverRequest = new HttpRequest($method, $uri, $headers, $body, $protocolVersion, $serverParams);

        return $serverRequest
            ->withCookieParams($_COOKIE)
            ->withQueryParams($_GET)
            ->withParsedBody($_POST)
            ->withUploadedFiles(HttpRequest::normalizeFiles($_FILES));
    }
}
