<?php

namespace IZON\MVC\Exceptions\Handlers;

use Psr\Log\LogLevel;
use Throwable;

/**
 * Handles if page is not found
 */
class ClientErrorExceptionHandler extends AbstractRecorevableExceptionHandler implements IAppExceptionHandler {

    /**
     * @var string<class-string>
     */
    protected string $exceptionClass;

    /**
     * @param string $defaultChain
     * @param string<class-string> $exceptionClass
     */
    public function __construct(
        ControllerChain $defaultChain,
        string $exceptionClass
    ) {
        parent::__construct($defaultChain);
        $this->exceptionClass = $exceptionClass;
    }

    public function getLogLevel() {
        return LogLevel::WARNING;
    }

    public function isFor(Throwable $exception): bool {
        return is_a($exception, $this->exceptionClass)
            || is_subclass_of($exception, $this->exceptionClass);
    }
}
