<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use \IZON\Logs\LogLevel;
use IZON\MVC\Controller;
use IZON\MVC\Controllers\SimpleErrorController;
use \IZON\MVC\Exceptions\PageNotFoundException;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\CompatibleWrapperInterceptor;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\Messages\HttpResponse;
use IZON\MVC\Messages\HttpResponseInterface;
use Throwable;

/**
 * Handles if page is not found
 */
class PageNotFoundExceptionHandler extends AbstractRecorevableExceptionHandler implements IAppExceptionHandler {

    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function isFor(Throwable $exception) {
        return $exception instanceof PageNotFoundException;
    }
}
