<?php

namespace IZON\MVC\Controllers;

use Exception;

use IZON\AppModules\Customers\Classes\CustomerLogin;
use IZON\AppModules\Customers\Web\Interceptors\CustomerIterceptor;
use \IZON\MVC\Controller;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use \IZON\MVC\ModelAndView;
use IZON\Templating\TemplateStream;

/**
 * controller that calls view with name $viewName and sets http_response_code passed in controller
 * usefull for 500 page
 */
class SimpleTemplateErrorController extends SimpleErrorController {

    /** @var integer */
    protected $httpResponseCode = 500;

    /** @var TemplateStream */
    protected $template;

    public function __construct($templateView, $httpResponseCode) {
        parent::__construct($templateView, $httpResponseCode);
        $this->httpResponseCode = $httpResponseCode;
        $this->template = new TemplateStream($templateView);
    }

    public function execute(HttpRequestInterface $request, HttpResponseInterface $response) {
        $response = $response->withStatus($this->httpResponseCode);
        return $response->withBody($this->template);
    }

    function setHttpResponseCode($httpResponseCode) {
        $this->httpResponseCode = $httpResponseCode;
    }
}
