<?php

namespace IZON\MVC\Controllers;

use Exception;

use \IZON\MVC\Controller;
use IZON\MVC\Messages\HttpRequestInterface;
use \IZON\MVC\ModelAndView;

/**
 * controller that calls view with name $viewName
 */
class SimpleController implements Controller {
    
    protected $viewName = NULL;

    public function __construct($viewName) {
        $this->viewName = $viewName;
    }

    public function execute(HttpRequestInterface $request) {
        if($this->viewName == NULL) {
            throw new Exception("viewName not set");
        }
        
        $modelAndView = new ModelAndView($this->viewName);
        return $modelAndView;
    }
}