<?php

namespace IZON\MVC\Controllers;

use Exception;

use \IZON\MVC\Controller;
use IZON\MVC\Messages\HttpRequestInterface;
use \IZON\MVC\ModelAndView;

/**
 * controller that makes redirect to some other controller
 */
class InternalRedirectController implements Controller {
    
    protected $controllerIdentifier = NULL;

    protected $parameters;

    /**
     * 
     * @param string  $controllerIdentifier controller id to redirect to
     * @param array $parameters parameters to use to redirect
     */
    public function __construct($controllerIdentifier, array $parameters = []) {
        $this->controllerIdentifier = $controllerIdentifier;
        $this->parameters = $parameters;
    }

    public function execute(HttpRequestInterface $request) {
        if($this->controllerIdentifier == NULL) {
            throw new Exception("controllerIdentifier not set");
        }
        
        $modelAndView = new ModelAndView($this->controllerIdentifier, 
                                            $this->parameters, 
                                            true);
        return $modelAndView;
    }
}