<?php


namespace IZON\MVC\Exceptions\Handlers;

use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use Exception;

abstract class AbstractRecorevableExceptionHandler implements IAppExceptionHandler {
    /**
     * @var ControllerChain
     */
    protected $defaultChain;
    /**
     * @var ControllerChain[]
     */
    protected $domainChains = [];

    /**
     * AbstractRecorevableExceptionHandler constructor.
     * @param ControllerChain $defaultChain
     */
    public function __construct(ControllerChain $defaultChain) {
        $this->defaultChain = $defaultChain;
    }

    public function addDomainChain(string $domainUID, ControllerChain $chain) {
        $this->domainChains[$domainUID] = $chain;
    }

    public function handleException(\Throwable $exception, ?HttpRequestInterface $request, ?HttpResponseInterface $response) : ?HttpResponseInterface {
        if(empty($request)) {
            throw new Exception(self::class . ' is not able to handle exception without HttpRequest object');
        }
        $chain = $this->defaultChain;
        if(array_key_exists($request->getDomainUID(), $this->domainChains)) {
            $chain = $this->domainChains[$request->getDomainUID()];
        }

        $interceptors  =$chain->getInterceptors();
        foreach ($interceptors as $interceptor) {
            $preHandleResult = $interceptor->preHandle($request);
            if ($preHandleResult instanceof PreHandleResult) {
                if($preHandleResult->isExternalRedirect() || $preHandleResult->isInternalRedirect()) {

                }
            }
        }

        $response = $chain->getController()->execute($request, $response);

        foreach ($interceptors as $interceptor) {
            $response =  $interceptor->postHandle($request, $response);
        }

        foreach($interceptors as $interceptor) {
            $response = $interceptor->afterCompletion($request, $response, null);
        }

        return $response;
    }

}
