<?php

namespace IZON\MVC\URLDomain;


class URLDomainResolver implements URLDomainResolverInterface {

    /**
     * @var array
     */
    protected $config;

    protected $reverse;

    /**
     * @var URLDomainService
     */
    protected $urlDomainService;

    /**
     * URLDomainResolver constructor.
     * @param URLDomainService $urlDomainService
     */
    public function __construct(URLDomainService $urlDomainService) {
        $this->urlDomainService = $urlDomainService;
        $this->config = $this->getDomainsConfig();
        $this->reverse = array_flip($this->config);
    }

    public function resolveCurrentDomain() : ?string {
        if(empty($_SERVER['HTTP_HOST'])) {
            return null;
        }
        $host = explode(':', $_SERVER['HTTP_HOST'])[0];
        return $this->resolveDomainUID($host);
    }

    public function resolveDomainName(string $domainUID): string {
        if(!array_key_exists($domainUID, $this->config)) {
            throw new \Exception("Usupported domain UID '$domainUID'");
        }
        return $this->config[$domainUID];
    }

    public function resolveDomainUID(string $domainName): string {
        if(!array_key_exists($domainName, $this->reverse)) {
            throw new \Exception("Usupported domain name '$domainName'");
        }
        return $this->reverse[$domainName];
    }

    /**
     * @return array
     * @throws \Exception
     */
    protected function getDomainsConfig(): array {
        $domainsConfig = $this->urlDomainService->getDomainList();
        if(count($domainsConfig) !== count(array_unique($domainsConfig))) {
            $domainsStr = implode(', ', $domainsConfig);
            throw new \Exception("Domains must be unique across system. Duplicate domains detected in domain config: {$domainsStr}");
        }
        return $domainsConfig;
    }

}
