<?php

namespace IZON\MVC\Interceptors;

use Exception;
use IZON\MVC\HttpRequest;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\ModelAndView;

/**
 * @author IZON s.r.o <info@izon.cz>
 * @copyright Copyright 2009, ZON s.r.o
 *
 * @package IZON\MVC\Interceptors
 * @deprecated use InterceptorInterface
 * interface defining interceptor to be called around controller
 */
interface Interceptor {

    /**
     * vyvolava se po volani view, slouzi predevsim k uklidu alokovanych zdroju atd.
     * @param HttpRequest $request information about request passed to server
     * @param Exception $exception vyjimka pokud byla nejaka vyvolanna, jinak null
     * @return mixed
     */
    public function afterCompletion(HttpRequest $request, $exception);

    /**
     * provede se po vyvolani controlleru ale pred vyvolanim view<br /><br />
     *
     * @param HttpRequest $request
     * @param ModelAndView $model
     */
    public function postHandle(HttpRequest $request, ModelAndView $model);

    /**
     * provadi se pred vyvolanim controlleru
     * muze vratit informace ktere mohou slouzit k presmerovani nebo dalsim akcim
     *
     * @param HttpRequest $request
     * @return NULL|PreHandleResult default return value is null
     */
    public function preHandle(HttpRequest $request);
}
