<?php

namespace IZON\MVC\Messages;

use Dflydev\FigCookies\Cookie;
use Dflydev\FigCookies\Cookies;
use Dflydev\FigCookies\FigRequestCookies;
use IZON\MVC\FlashMessage;
use IZON\MVC\Session\HttpSession;
use \IZON\Utils\Locale;
;

/**
 * Trida obsluhujici request
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version 1.0
 *
 * @package MVC
 */
class HttpRequest extends \GuzzleHttp\Psr7\ServerRequest implements HttpRequestInterface, \IZON\MVC\HttpRequest {

    /**
     * ????
     * @var string indentifikator volaneho controlleru, mel by nastavit router
     */
    protected $calledControllerId;

    /**
     * NOTE: currnetly to allow backward compatibility
     * @var string
     */
    protected $url;
    /**
     * doména
     * @var string
     */
    private $domain;
    /**
     * @var string
     */
    private $domainUID;

    protected $parameters = [];

    protected $innerObjects = [];

    public function hasParameter(string $paramName) {
        return array_key_exists($paramName, $this->getQueryParams())
            || is_array($this->getParsedBody()) && array_key_exists($paramName, $this->getParsedBody())
            || array_key_exists($paramName, $this->parameters);
    }

    /**
     * vraci parametr z requestu
     */
    public function getParameter(string $paramName) {
        if(array_key_exists($paramName, $this->getQueryParams())) {
            return $this->getQueryParams()[$paramName];
        } else if(is_array($this->getParsedBody()) && array_key_exists($paramName, $this->getParsedBody())) {
            return $this->getParsedBody()[$paramName];
        } else if(array_key_exists($paramName, $this->parameters)) {
            return $this->parameters[$paramName];
        } else {
            return NULL;
        }
    }

    /**
     * TODO: neni ciste pozdeji odstranit
     * @param type $parameters
     */
    public function addParameter($parameterName, $parameter) {
        $this->parameters[$parameterName] = $parameter;
    }

    /**
     * vraci pole vsech parametru z requestu, to same jako $_REQUEST
     */
    public function getParameters() {
        $params = [];

        foreach($this->getQueryParams() as $key => $param) {
            $params[$key] = $param;
        }
        if(is_iterable($this->getParsedBody())) {
            foreach($this->getParsedBody() as $key => $param) {
                $params[$key] = $param;
            }
        }
        foreach($this->parameters as $key => $param) {
            $params[$key] = $param;
        }

        return $params;
    }


    public function withDomainUID(string $domainUID) {
        $clone = clone $this;
        $clone->domainUID = $domainUID;
        return $clone;
    }

    public function withDomain(string $domain) {
        $clone = clone $this;
        $clone->domain = $domain;
        return $clone;
    }

    public function getSession() {
        return $this->innerObjects['session'];
    }

    function withSession(?HttpSession $session) {
        $clone = clone $this;
        $clone->innerObjects['session'] = $session;
        return $clone;
    }

    /**
     * vraci parametr ze session
     */
    public function getSessionParameter($name) {
        $this->getSession()->lock();
        $value = $this->getSession()->getParameter($name);
        $this->getSession()->unlock();
        return $value;
    }

    /**
     * ulozi parametr do session
     */
    public function setSessionParameter($name, $value) {
        $this->getSession()->lock();
        $this->getSession()->setParameter($name, $value);
        $this->getSession()->unlock();
    }

    function getLocale() {
        return $this->innerObjects['locale'] ?? null;
    }

    /**
     * TODO: neni ciste potom odstranit
     * @param Locale $locale
     */
    function withLocale(?Locale $locale) {
        $clone = clone $this;
        $clone->innerObjects['locale'] = $locale;
        return $clone;
    }

    function getCalledControllerId() {
        return $this->calledControllerId;
    }

    function setCalledControllerId($calledControllerId) {
        $this->calledControllerId = $calledControllerId;
    }

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @deprecated Use Context::addFlashMessage instead
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessageWeb($content, $id = NULL, $level = FlashMessage::LEVEL_OK) {
        $this->_setFlashMessage('web', $content, $id, $level);
    }

    function getURL() {
        return $this->url;
    }

    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu. Aktualne nahrazeno setFlashMessageWeb
     *
     * @deprecated Use Context::addFlashMessage instead
     *
     * @param string $content obsah zpravy
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $level [OK|WARNING|ERROR]
     */
    public function setFlashMessage($content, $id = NULL, $level = FlashMessage::LEVEL_OK) {
        $this->_setFlashMessage('web', $content, $id, $level);
    }
    /**
     * Ulozi FlashMessage do session pod jejim id pro pouziti na webu
     *
     * @deprecated Use Context::addFlashMessage instead
     *
     * @param FlashMessage|string $id objekt FlashMessage nebo identifikator zpravy
     * @param string $id identifier
     * @param string $level [OK|WARNING|ERROR]
     *
     */
    public function setFlashMessageAdmin($content, $id = NULL, $level = FlashMessage::LEVEL_OK) {
        $this->_setFlashMessage('admin', $content, $id, $level);
    }

    function setURL($url) {
        $this->url = $url;
    }

    /**
     * Save flash messaage into SESSION
     *
     * @param string $context [web|admin]
     * @param FlashMessage|string $content objekt FlashMessage nebo textovy obsah zpravy
     * @param string $type type of message to store
     * @param string $level [OK|WARNING|ERROR]
     */
    protected function _setFlashMessage($context, $content, $type = NULL, $level = FlashMessage::LEVEL_OK) {
        $message = $content;
        if( !($content instanceof FlashMessage) ) { // zprava se nepredava jako objekt
            $message = new FlashMessage($content, $type, $level);
        }
        $this->getSession()->lock();
        $messages = $this->getSessionParameter('flashMessages');
        $messages[$context][$message->getType()] = [$message];
        $this->setSessionParameter('flashMessages', $messages);
        $this->getSession()->unlock();
    }

    /**
     * @return string
     */
    public function getDomain(): string {
        return $this->domain;
    }

    /**
     * @return string
     */
    public function getDomainUID(): string {
        return $this->domainUID;
    }

    public function getCookies() : Cookies {
        return Cookies::fromRequest($this);
    }

    public function getCookie(string $name) : Cookie {
        return FigRequestCookies::get($this, $name);
    }


}
