<?php

namespace IZON\MVC\Controllers;

use Exception;

use \IZON\MVC\Controller;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use \IZON\MVC\ModelAndView;

/**
 * controller that calls view with name $viewName and sets http_response_code passed in controller
 * usefull for 500 page
 */
class SimpleErrorController implements Controller {

    /**
     * @var string
     */
    protected $viewName;

    /**
     * @var integer
     */
    protected $httpResponseCode = 500;


    public function __construct($viewName, $httpResponseCode) {
        $this->viewName = $viewName;
        $this->httpResponseCode = $httpResponseCode;
    }

    public function execute(HttpRequestInterface $request, HttpResponseInterface $response) {
        if($this->viewName == NULL) {
            throw new Exception("viewName not set");
        }

        $response = $response->withStatus($this->httpResponseCode);

        $modelAndView = new ModelAndView($this->viewName);
        $response = $response->withModelAndView($modelAndView);
        return $response;
    }

    function setHttpResponseCode($httpResponseCode) {
        $this->httpResponseCode = $httpResponseCode;
    }
}
