<?php

namespace IZON\MVC\URLDomain;

use IZON\MVC\Config;

/**
 * Class URLDomainService
 * @package IZON\MVC\URLDomain
 */
class URLDomainService {

    /**
     * @var array
     */
    protected $appConfig;

    /**
     * URLDomainService constructor.
     * @param array $appConfig
     */
    public function __construct(array $appConfig) {
        $this->appConfig = $appConfig;
    }

    /**
     * Returns flat array of domains. Key is domainUID, value is domainName.
     *
     * @return array
     */
    public function getDomainList(): array {
        $appConfig = $this->appConfig;
        $list =  [];
        foreach($appConfig as $appUid => $domains) {
            $list = array_merge($list, $domains);
        }
        return $list;
    }

    /**
     * @param string $domainUID
     * @return string|null
     * @throws \Exception
     */
    public function getDomainName(string $domainUID): ?string {
        if(!isset($this->getDomainList()[$domainUID])) {
            throw new \Exception("Domain for domainUID {$domainUID} not found.");
        }
        return $this->getDomainList()[$domainUID];
    }

}
