<?php

namespace IZON\MVC\Routers\Factories;

use IZON\MVC\Locale\LocaleResolver;
use IZON\MVC\Routers\Helpers\Route;
use IZON\MVC\Routers\RouteDefinition;
use IZON\MVC\Routers\Router;
use IZON\MVC\URLDomain\URLDomainResolverInterface;

/**
 * Description of RouterFactory
 *
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class RouterFactory implements IRouterFactory {

    /**
     *
     * @var RouteDefinition[]
     */
    protected $routerDefinitions;

    /**
     *
     * @var LocaleResolver
     */
    protected $localeResolver;

    /**
     * @var URLDomainResolverInterface
     */
    protected $domainResolver;

    /**
     *
     * @var bool
     */
    protected $redirectWithoutTailingSlash;

    /**
     * @var string[] interceptors to  be called for each request resolved by this router
     */
    protected $commonInterceptors = [];

    /**
     * @var Route
     */
    protected $router;


    public function __construct(
        array $routerDefinitions,
        LocaleResolver $localeResolver,
        URLDomainResolverInterface $domainResolver,
        $redirectWithoutTailingSlash
    ) {
        $this->routerDefinitions = $routerDefinitions;
        $this->localeResolver = $localeResolver;
        $this->domainResolver = $domainResolver;
        $this->redirectWithoutTailingSlash = $redirectWithoutTailingSlash;
    }

    public function create() {
        if(empty($this->router)) {
            /** @var $router Router */
            $router = new Router($this->routerDefinitions);

            $router->setLocaleResolver($this->localeResolver);
            $router->setDomainResolver($this->domainResolver);

            if(!empty($this->redirectWithoutTailingSlash)) {
                $router->setRedirectToURLWithoutTailingSlash($this->redirectWithoutTailingSlash);
            }

            $router->setCommonInterceptors($this->commonInterceptors);

            $this->router = $router;
        }
        return $this->router;
    }

    /**
     * @param string[] $commonInterceptors interceptors called always
     */
    function setCommonInterceptors(array $commonInterceptors) {
        $this->commonInterceptors = $commonInterceptors;
    }
}
