<?php

namespace IZON\MVC\Messages;

use Dflydev\FigCookies\SetCookie;
use Dflydev\FigCookies\SetCookies;
use IZON\MVC\ModelAndView;

/**
 *
 */
interface HttpResponseInterface extends \Psr\Http\Message\ResponseInterface {

    public function withModelAndView(?ModelAndView $modelAndView): HttpResponseInterface;

    public function getModelAndView(): ?ModelAndView;

    public function getSetCookies(): SetCookies;

    public function withCookie(SetCookie $cookie): HttpResponseInterface;

    public function withoutCookie(string $cookieName): HttpResponseInterface;

    public function expireCookie(string $cookieName): HttpResponseInterface;
}
