<?php

namespace IZON\MVC\Gettext;

use IZON\Utils\Locale;

class GettextLocaleManager {
    /**
     * @var string
     */
    protected $localeDir;
    /**
     * @var string
     */
    protected $tmpDir;
    /**
     * @var bool
     */
    protected $develserver;

    /**
     * @var Locale|null
     */
    protected $currentLocale;

    /**
     * GettextLocaleManager constructor.
     * @param string $localeDir
     * @param string $tmpDir
     * @param bool $develserver
     */
    public function __construct(string $localeDir, string $tmpDir, bool $develserver) {
        $this->localeDir = $localeDir;
        $this->tmpDir = $tmpDir;
        $this->develserver = $develserver;
    }


    public function setupLanguage(Locale $locale) {
        if($locale !== $this->currentLocale) {
            $this->initGettext($locale);
        }
    }

    public function getCurrentLocale() : ?Locale {
        return $this->currentLocale;
    }

    protected function initGettext(Locale $locale) {
        // create locale string as used in OS
        $osLocaleTag = str_replace("-", '_', $locale->toLocaleTag());
        $domain = $locale->getLanguage();

        // tries to set exactlly $selectedLocale locale, if not found on os select one of 'cs_CZ', 'cs', 'en_US', 'en'
        $osFallbackLocaleTag = setlocale(LC_ALL, $osLocaleTag, 'cs_CZ', 'cs', 'en_US', 'en');

        // set formating for numbers to english NEEDS TO BE TESTED
        setlocale(LC_NUMERIC, 'C');
        putenv('LANGUAGE='.$osFallbackLocaleTag);

        // location of translation .mo file
        $localeFilePath = $this->localeDir.'/'.$osLocaleTag."/LC_MESSAGES/$domain.mo";
        if(file_exists($localeFilePath)) { // we have locale
            $mtime = filemtime($localeFilePath);

            // fix for php7+ and windows 10
            if($this->develserver && getenv('OS') == 'Windows_NT') { // is devel mode and windows 10 os
                $osFallbackLocaleTag = 'cs'; // it probably will be function on cs OS
            }

            // where to store temoporary locale
            $newLocaleDir = $this->tmpDir.'/'.$osFallbackLocaleTag.'/LC_MESSAGES';
            $newDomain = 'messages_'.$domain;

            $timestampedDomain = $newDomain.'_'.$mtime;
            $newLocaleFilePath = $newLocaleDir.'/'.$timestampedDomain.'.mo';

            if(!is_dir($newLocaleDir)) {
                mkdir($newLocaleDir, 0777, true);
            }
            if(!file_exists($newLocaleFilePath)) {
                copy($localeFilePath, $newLocaleFilePath);
                chmod($newLocaleFilePath, 0777);
            }

            bindtextdomain($timestampedDomain, $this->tmpDir);
            textdomain($timestampedDomain);
            bind_textdomain_codeset($timestampedDomain, 'UTF-8');
        }
    }
}
